;===============================================================================
;       Mosaic.asm
;===============================================================================
.486
.model      flat, stdcall
option      casemap: none

includelib  \masm32\lib\kernel32.lib
includelib  \masm32\lib\user32.lib
includelib  \masm32\lib\gdi32.lib
includelib  \masm32\lib\comctl32.lib
includelib  \masm32\lib\comdlg32.lib
include     \masm32\include\kernel32.inc
include     \masm32\include\comctl32.inc
include     \masm32\include\comdlg32.inc
include     \masm32\include\user32.inc
include     \masm32\include\gdi32.inc
include     \masm32\include\windows.inc
include     mosaic.inc
WinMain     	PROTO STDCALL   :DWORD, :DWORD, :DWORD, :DWORD
WndProc     	PROTO STDCALL   :DWORD, :DWORD, :DWORD, :DWORD
InitControls	PROTO STDCALL	:DWORD
InitBitmaps		PROTO STDCALL 	:DWORD
DeleteBitmaps	PROTO STDCALL
SetBitmap		PROTO STDCALL 	:DWORD, :DWORD
GetCoordinates	PROTO STDCALL 	:DWORD
DrawNumbers		PROTO STDCALL
CreateTiles		PROTO STDCALL
DrawProc		PROTO STDCALL 	:DWORD, :DWORD
InitGame		PROTO STDCALL 	:DWORD
.data



.data
AppName             db      "Mosaic",0
ClassName           db      "Mosaic32",0
DefaultStatusText   db      "Mosaic 1.0",0 
ClassStatic			db		"STATIC",0
StatusParts			dd		90,90+80,-1
FontFace			db		"Arial",0
.data?
hInstance       dd      ?
hMenu           dd      ?
hStatic			dd		?
hToolbar		dd		?
hStatus       	dd      ?

BackBufferDC		dd	?
hBackBuffer			dd	?
ImageDC				dd	?
hImage				dd	?
hBackgroundColor	dd	?
hTileColor			dd	?
hFont				dd	?
TextColor			dd	?
CurImageType		dd		?		;Current image type

.data
ToolbarButtons	TBBUTTON	<0, MI_OPENBITMAP, TBSTATE_ENABLED	, TBSTYLE_BUTTON,0, NULL, NULL> 
				TBBUTTON	<1, MI_NEWGAME, TBSTATE_ENABLED	, TBSTYLE_BUTTON,0, NULL, NULL>
				
				TBBUTTON	<NULL, NULL, NULL, TBSTYLE_SEP, NULL, NULL>;--- seperator
				
				TBBUTTON	<2, MI_USESTANDARD, TBSTATE_ENABLED	+TBSTATE_CHECKED, TBSTYLE_CHECKGROUP,0, NULL, NULL>
				TBBUTTON	<3, MI_USENUMBERS, TBSTATE_ENABLED	, TBSTYLE_CHECKGROUP,0, NULL, NULL>
				TBBUTTON	<4, MI_USEFILE, TBSTATE_ENABLED	, TBSTYLE_CHECKGROUP,0, NULL, NULL>
				
				TBBUTTON	<NULL, NULL, NULL, TBSTYLE_SEP, NULL, NULL>;--- seperator
				
				TBBUTTON	<5, MI_ABOUT, TBSTATE_ENABLED, TBSTYLE_BUTTON,0, NULL, NULL>


.code
    start:
    ; Get module handle and save it
    invoke  GetModuleHandle, NULL
    mov     hInstance, eax
    
    ; Init Common Controls library
    invoke  InitCommonControls
    
    ; Run winmain procedure and exit program
    invoke  WinMain, hInstance, NULL, NULL, SW_SHOWNORMAL
    invoke  ExitProcess,eax

;===============================================================================
; WinMain
;===============================================================================
WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
LOCAL wc:WNDCLASSEX
LOCAL msg:MSG
LOCAL hwnd:HWND
    mov     wc.cbSize,SIZEOF WNDCLASSEX
    mov     wc.style, CS_HREDRAW or CS_VREDRAW
    mov     wc.lpfnWndProc, OFFSET WndProc
    mov     wc.cbClsExtra,NULL
    mov     wc.cbWndExtra,NULL
    push    hInstance
    pop     wc.hInstance
    mov     wc.hbrBackground,COLOR_WINDOW
    mov     wc.lpszMenuName, NULL
    mov     wc.lpszClassName,OFFSET ClassName
    invoke  LoadIcon, hInstance, ICON1_BIG
    mov     wc.hIcon, eax
    invoke  LoadIcon, hInstance, ICON2_SMALL
    mov     wc.hIconSm, eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx, addr wc
    invoke  LoadMenu, hInstance, MAINMENU ;load menu
    mov     hMenu, eax                    ;store handle
    INVOKE  CreateWindowEx,NULL,ADDR ClassName,ADDR AppName,\
            WS_OVERLAPPEDWINDOW-WS_MAXIMIZEBOX-WS_SIZEBOX,\
            CW_USEDEFAULT, CW_USEDEFAULT,258,350,NULL,hMenu,\
            hInst,NULL
    mov     hwnd,eax
    invoke  ShowWindow, hwnd, CmdShow
    invoke  UpdateWindow, hwnd
    .WHILE  TRUE
        invoke  GetMessage, ADDR msg,NULL,0,0
        .BREAK  .IF (!eax)
        invoke  TranslateMessage, ADDR msg
        invoke  DispatchMessage, ADDR msg
    .ENDW
    mov     eax,msg.wParam
    ret
WinMain endp



    
;===============================================================================
;   Window procedure
;===============================================================================    
WndProc proc    hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
mov eax, uMsg
    .IF     eax==WM_CREATE
       	invoke	InitControls, hWnd
       	invoke	InitBitmaps, hWnd
       	invoke	InitGame, hWnd
    .ELSEIF eax==WM_DRAWITEM
		mov		eax, wParam
		.IF		eax==CID_STATIC
			push	ebx
			mov		ebx, lParam
			assume	ebx:ptr DRAWITEMSTRUCT
			invoke	DrawProc, hWnd, [ebx].hdc
			assume	ebx:nothing
			pop		ebx
			xor		eax, eax
			inc		eax
		.ELSE
			xor 	eax, eax
		.ENDIF
    .ELSEIF eax==WM_DESTROY
        invoke  PostQuitMessage, NULL
    .ELSE
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam       
        ret
    .ENDIF
ret
WndProc endp

;================================================================================
;                           Init Controls
;================================================================================
InitControls proc hWnd:DWORD
LOCAL DefaultFont:DWORD
	;--- Create static window for mosaic: ---
    invoke  CreateWindowEx, WS_EX_CLIENTEDGE, ADDR ClassStatic, NULL,\
            WS_VISIBLE + WS_CHILD + SS_OWNERDRAW    ,\
            15, 55, 220, 220,\
            hWnd, CID_STATIC, hInstance, NULL
    mov     hStatic, eax
    
    
    ;--- save default font ---
    invoke  GetStockObject, DEFAULT_GUI_FONT
    mov     DefaultFont, eax
    
    ;--- create the toolbar window ---
   	invoke	CreateToolbarEx, hWnd, WS_CHILD + WS_VISIBLE + TBSTYLE_FLAT + WS_BORDER,\
			CID_TOOLBAR, 6, hInstance, BMP_TOOLBAR, ADDR ToolbarButtons,\
			8, 32, 32, 32, 32, SIZEOF TBBUTTON
	mov		hToolbar, eax
	invoke	SendMessage, eax, TB_AUTOSIZE, NULL, NULL 

    ; Create statusbar window:
    invoke  CreateStatusWindow, WS_CHILD + WS_VISIBLE,\
             ADDR DefaultStatusText, hWnd, CID_STATUS
    mov     hStatus, eax
    invoke  SendMessage, hStatus, WM_SETFONT, DefaultFont, TRUE 
    invoke  SendMessage, hStatus, SB_SETPARTS,3, ADDR StatusParts
    
ret
InitControls endp



;================================================================================
;							Init Bitmaps
;================================================================================
InitBitmaps proc hWnd:DWORD
; Create DC's for backbuffer and current image
	invoke 	CreateCompatibleDC, NULL
	mov		BackBufferDC, eax
	
	invoke	CreateCompatibleDC, NULL
	mov		ImageDC, eax

; Create bitmap for backbuffer:
	invoke	GetDC, hWnd
	push 	eax
	invoke	CreateCompatibleBitmap, eax, 200+20,200+20
	mov		hBackBuffer, eax
	pop		eax
	invoke	ReleaseDC, hWnd, eax
	invoke	SelectObject, BackBufferDC, hBackBuffer
	
; Create Arial font for the numbers	
	invoke	CreateFont, -30, NULL, NULL, NULL, FW_EXTRABOLD, \
			FALSE, FALSE, FALSE, NULL, NULL, NULL, NULL, NULL, ADDR FontFace
	mov		hFont, eax

; Select font in Image DC
   invoke	SelectObject, ImageDC, hFont

   invoke	CreateSolidBrush, 0FF8000h
   mov		hBackgroundColor, eax
   invoke	CreateSolidBrush, 0FF8080h
   mov		hTileColor, eax
   
   mov		TextColor, 0800000h
ret
InitBitmaps endp

;================================================================================
;							Delete Bitmaps
;================================================================================
DeleteBitmaps proc
	invoke	DeleteDC, BackBufferDC
	invoke	DeleteDC, ImageDC
	invoke	DeleteObject, hImage
	invoke	DeleteObject, hBackBuffer
	invoke	DeleteObject, hFont
	invoke	DeleteObject, hBackgroundColor
	invoke	DeleteObject, hTileColor
ret
DeleteBitmaps endp

;================================================================================
;							Set Bitmap
;================================================================================
SetBitmap	proc hWnd:DWORD, ImageType:DWORD
	mov 	eax, ImageType
	.IF	eax==IMAGETYPE_NUMBERS
		;--- delete old image ---
		invoke	DeleteObject, hImage
		;--- Get DC ---
		invoke	GetDC, hWnd
		push 	eax
		;--- Create new bitmap for the numbers bitmap ---
		invoke	CreateCompatibleBitmap, eax, 200, 200
		mov		hImage, eax
		pop		eax
		;--- Release DC ---
		invoke	ReleaseDC, hWnd, eax
		;--- Select new bitmap in DC ---
		invoke	SelectObject, ImageDC, hImage
		;--- Draw numbers on the bitmap ---
		invoke	DrawNumbers
		;--- Create the 3D effect on the bitmap ---
		invoke	CreateTiles
	.ENDIF
	;--- Set the new image type ---
	mov		eax, ImageType
	mov		CurImageType, eax
ret
SetBitmap	endp


.data
NumberFormat	db		"%lu",0
Rect200			RECT	<0,0,200,200>
.data?
Buffer			db		200 dup (?)
.code
;================================================================================
;							Draw Numbers
;================================================================================
DrawNumbers proc uses ebx edi
LOCAL	TempRect:RECT
	; --- Set the textcolor of ImageDC to TextColor ---
	invoke	SetTextColor, ImageDC, TextColor
	; --- Fill the imageDC with the tile color brush ---
	invoke	FillRect, ImageDC, ADDR Rect200, hTileColor
	; --- Set the background mode to transparent (for the text) ---
	invoke	SetBkMode, ImageDC, TRANSPARENT
	
	; --- Loop through all the numbers and draw them one by one ---
	xor		ebx, ebx
	.WHILE	ebx<16
		mov		eax, ebx
		inc		eax
		invoke	GetCoordinates, eax
		mov		dx, ax		; dx  = row
		shr		eax, 16 	; ax  = column
		and		edx, 0ffffh	; make sure that edx = dx
		imul	edx, edx, 50;} Multipy edx as well as eax with 50
		imul	eax, 50		;} 
		mov		TempRect.left, eax
		mov		TempRect.top, edx
		add		eax, 50
		add		edx, 50
		mov		TempRect.right, eax
		mov		TempRect.bottom, edx
		mov		eax, ebx
		inc		eax
		invoke	wsprintf, ADDR Buffer, ADDR NumberFormat, eax
		invoke	DrawText, ImageDC, ADDR Buffer, -1, ADDR TempRect,\
				DT_CENTER or DT_SINGLELINE or DT_VCENTER
	inc ebx
	.ENDW
ret
DrawNumbers endp

;================================================================================
;							GetCoordinates
;================================================================================
GetCoordinates proc	dwTile:DWORD
	mov		eax, dwTile
	dec		eax
	cdq
	mov		ecx, 4
	div		ecx
	;eax=quotient = row
	;edx=remainder = column
	shl 	edx, 16
	add		eax, edx
ret
GetCoordinates endp

;================================================================================
;							Create Tiles
;================================================================================
CreateTiles proc uses ebx esi edi
	invoke	GetStockObject, BLACK_PEN
	invoke	SelectObject, ImageDC, eax
; Dark lines, vertical. x = 50k - 1 (k=1,2,3,4)
; ebx = k
; esi = x
	xor 	ebx, ebx	
	inc		ebx	
	; ebx is 1 now
	
	.WHILE	ebx<5 	; (ebx= 1,2,3,4)
		mov		eax, 50
		mul		ebx
		mov		esi, eax
		dec		esi
		invoke	MoveToEx, ImageDC, esi, 0, NULL
		invoke	LineTo, ImageDC, esi, 199
	inc ebx
	.ENDW

; Dark lines, horizontal. y = 50k - 1 (k=1,2,3,4)
; ebx = k
; esi = y
	xor 	ebx, ebx	
	inc		ebx	
	; ebx is 1 now
	.WHILE	ebx<5 	; (ebx= 1,2,3,4)
		mov		eax, 50
		mul		ebx
		mov		esi, eax
		dec		esi
		invoke	MoveToEx, ImageDC, 0, esi, NULL
		invoke	LineTo, ImageDC, 199, esi
	inc	ebx
	.ENDW
	invoke	GetStockObject, WHITE_PEN
	invoke	SelectObject, ImageDC, eax
; Light lines, vertical. x = 50k  (k=0,1,2,3)
; ebx = k
; esi = x
	xor 	ebx, ebx	

	.WHILE	ebx<4 	; (ebx= 0,1,2,3)
		mov		eax, 50
		mul		ebx
		mov		esi, eax
		invoke	MoveToEx, ImageDC, esi, 0, NULL
		invoke	LineTo, ImageDC, esi, 199
	inc ebx
	.ENDW

; Light lines, horizontal. y = 50k (k=0,1,2,3)
; ebx = k
; esi = y
	xor 	ebx, ebx	

	; ebx is 1 now
	
	.WHILE	ebx<4 	; (ebx= 0,1,2,3)
		mov		eax, 50
		mul		ebx
		mov		esi, eax
		invoke	MoveToEx, ImageDC, 0, esi, NULL
		invoke	LineTo, ImageDC, 199, esi
	inc	ebx
	.ENDW
	
ret
CreateTiles endp

;================================================================================
;							Draw Numbers
;================================================================================
DrawProc proc uses ebx edi esi hWnd:DWORD, hDC:DWORD
	invoke	BitBlt, hDC, 9, 9, 220, 220, ImageDC, 0, 0, SRCCOPY
ret
DrawProc endp
;================================================================================
;							InitGame
;================================================================================
InitGame	proc	hWnd:DWORD
	invoke	SetBitmap, hWnd, IMAGETYPE_NUMBERS
ret
InitGame	endp


end start

